'use client';

import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { Button } from '@/components/ui/button';
import { Package, ListOrdered, Settings, BookText } from 'lucide-react';

export default function AdminNav() {
  const pathname = usePathname();

  const getVariant = (path: string) => {
    return pathname.startsWith(path) ? 'default' : 'outline';
  }

  return (
    <div className="mb-6 flex items-center gap-2 flex-wrap">
      <Button asChild variant={getVariant('/admin/products')}>
        <Link href="/admin/products">
          <Package className="mr-2 h-4 w-4" />
          Gerenciar Produtos
        </Link>
      </Button>
      <Button asChild variant={getVariant('/admin/orders')}>
        <Link href="/admin/orders">
          <ListOrdered className="mr-2 h-4 w-4" />
          Visualizar Pedidos
        </Link>
      </Button>
      <Button asChild variant={getVariant('/admin/settings')}>
        <Link href="/admin/settings">
          <Settings className="mr-2 h-4 w-4" />
          Configurações
        </Link>
      </Button>
      <Button asChild variant={getVariant('/admin/documentation')}>
        <Link href="/admin/documentation">
          <BookText className="mr-2 h-4 w-4" />
          Documentação
        </Link>
      </Button>
    </div>
  );
}
